terraform {
  required_version = ">= 1.0.0, < 2.0.0"

  required_providers {
    aws = {
      source  = "hashicorp/aws"
      version = "~> 4.0"
    }
  }

  backend "s3" {

    # Ten plik konfiguracyjny w trakcie testu będzie wypełniony automatycznie
    # przez Terratest. Jeżeli chcesz ten przykład wykonać ręcznie, usuń znaki
    # komentarza na początku poniższych wierszy i uzupełnij je żądanymi danymi.

    # bucket         = "<NAZWA KUBEŁKA S3>"
    # key            = "<ŚCIEŻKA DOSTĘPU>/terraform.tfstate"
    # region         = "us-east-2"
    # dynamodb_table = "<NAZWA TABELI DYNAMODB>"
    # encrypt        = true

  }
}

provider "aws" {
  region = "us-east-2"
}

resource "aws_instance" "example" {
  ami           = "ami-0fb653ca2d3203ac1"

  instance_type = terraform.workspace == "default" ? "t2.medium" : "t2.micro"

}

